/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.AID;
import jade.core.Agent;
import jade.core.AgentContainer;
import jade.core.AgentDescriptor;
import jade.core.AgentManager;
import jade.core.AgentState;
import jade.core.CaseInsensitiveString;
import jade.core.Channel;
import jade.core.CommandProcessor;
import jade.core.ContainerID;
import jade.core.ContainerTable;
import jade.core.GADT;
import jade.core.GenericCommand;
import jade.core.IMTPException;
import jade.core.Location;
import jade.core.MainContainer;
import jade.core.NameClashException;
import jade.core.NodeDescriptor;
import jade.core.NotFoundException;
import jade.core.PlatformManager;
import jade.core.PlatformManagerImpl;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.UnreachableException;
import jade.core.behaviours.Behaviour;
import jade.core.event.MTPEvent;
import jade.core.event.PlatformEvent;
import jade.domain.FIPAAgentManagement.AMSAgentDescription;
import jade.domain.FIPAAgentManagement.AlreadyRegistered;
import jade.domain.FIPAAgentManagement.NotRegistered;
import jade.domain.ams;
import jade.domain.df;
import jade.mtp.MTPDescriptor;
import jade.mtp.MTPException;
import jade.security.Credentials;
import jade.security.JADEPrincipal;
import jade.security.JADESecurityException;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import jade.util.leap.Iterator;
import jade.util.leap.LinkedList;
import jade.util.leap.List;

public class MainContainerImpl
implements MainContainer,
AgentManager {
    private ams theAMS;
    private df defaultDF;
    private ContainerID localContainerID;
    private PlatformManagerImpl myPlatformManager;
    private CommandProcessor myCommandProcessor;
    private List platformListeners = new LinkedList();
    private List platformAddresses = new LinkedList();
    private List agentTools = new LinkedList();
    private ContainerTable containers = new ContainerTable();
    private GADT platformAgents = new GADT();
    private Logger myLogger = Logger.getMyLogger(this.getClass().getName());

    public MainContainerImpl(Profile p, PlatformManagerImpl pm) throws ProfileException {
        this.myCommandProcessor = p.getCommandProcessor();
        this.myPlatformManager = pm;
        this.theAMS = new ams(this);
        this.defaultDF = new df();
    }

    public PlatformManager getPlatformManager() {
        return this.myPlatformManager;
    }

    void addLocalContainer(ContainerID cid) {
        this.containers.addContainer(cid);
        this.localContainerID = cid;
    }

    void removeLocalContainer(ContainerID cid) {
        Agent systemAgent = this.defaultDF;
        systemAgent.doDelete();
        systemAgent.join();
        systemAgent.resetToolkit();
        systemAgent = this.theAMS;
        systemAgent.doDelete();
        systemAgent.join();
        systemAgent.resetToolkit();
        this.removeListener(this.theAMS);
    }

    void addRemoteContainer(ContainerID cid) {
        this.containers.addContainer(cid);
        this.fireAddedContainer(cid);
    }

    void removeRemoteContainer(ContainerID cid) {
        this.removeAllMTPs(cid);
        this.containers.removeContainer(cid);
        this.removeAllAgents(cid);
        this.fireRemovedContainer(cid);
    }

    void initSystemAgents(AgentContainer ac) throws IMTPException, NotFoundException, JADESecurityException {
        ContainerID cid = ac.getID();
        NodeDescriptor dsc = this.getDescriptor(cid.getName());
        JADEPrincipal cp = dsc.getOwnerPrincipal();
        try {
            AID amsId = ac.getAMS();
            ac.initAgent(amsId, this.theAMS, cp, null);
        }
        catch (Exception e) {
            throw new IMTPException("Exception during AMS initialization", e);
        }
        try {
            AID dfId = ac.getDefaultDF();
            ac.initAgent(dfId, this.defaultDF, cp, null);
        }
        catch (Exception e) {
            throw new IMTPException("Exception during Default DF initialization", e);
        }
    }

    void startSystemAgents(AgentContainer ac) throws IMTPException, NotFoundException, JADESecurityException {
        this.theAMS.resetEvents(true);
        AID amsId = ac.getAMS();
        ac.powerUpLocalAgent(amsId);
        this.theAMS.waitUntilStarted();
        AID dfId = ac.getDefaultDF();
        ac.powerUpLocalAgent(dfId);
        this.defaultDF.waitUntilStarted();
    }

    void installAMSBehaviour(Behaviour b) {
        this.theAMS.addBehaviour(b);
    }

    void uninstallAMSBehaviour(Behaviour b) {
        this.theAMS.removeBehaviour(b);
    }

    public void bornAgent(AID name, ContainerID cid, JADEPrincipal principal, String ownership, boolean forceReplacement) throws NameClashException, NotFoundException {
        AgentDescriptor ad = new AgentDescriptor(false);
        ad.setContainerID(cid);
        ad.setPrincipal(principal);
        AMSAgentDescription amsd = new AMSAgentDescription();
        amsd.setName(name);
        amsd.setOwnership(ownership);
        amsd.setState("active");
        ad.setDescription(amsd);
        AgentDescriptor old = this.platformAgents.put(name, ad);
        if (old != null) {
            if (old.isNative()) {
                if (forceReplacement) {
                    System.out.println("Replacing a dead agent ...");
                    this.fireDeadAgent(old.getContainerID(), name, false);
                } else if (!old.getDescription().getState().equals("latent")) {
                    this.platformAgents.put(name, old);
                    throw new NameClashException("Agent " + name + " already present in the platform ");
                }
            } else {
                this.platformAgents.put(name, old);
                throw new NameClashException("Agent " + name + " already registered to the platform ");
            }
        }
        this.fireBornAgent(cid, name, ownership);
    }

    public void deadAgent(AID name, boolean containerRemoved) throws NotFoundException {
        AgentDescriptor ad = this.platformAgents.acquire(name);
        if (ad == null) {
            throw new NotFoundException("DeadAgent failed to find " + name);
        }
        ContainerID cid = ad.getContainerID();
        this.platformAgents.remove(name);
        this.fireDeadAgent(cid, name, containerRemoved);
    }

    public void suspendedAgent(AID name) throws NotFoundException {
        AgentDescriptor ad = this.platformAgents.acquire(name);
        if (ad == null) {
            throw new NotFoundException("SuspendedAgent failed to find " + name);
        }
        AMSAgentDescription amsd = ad.getDescription();
        if (amsd != null) {
            amsd.setState("suspended");
        }
        ContainerID cid = ad.getContainerID();
        this.platformAgents.release(name);
        this.fireSuspendedAgent(cid, name);
    }

    public void resumedAgent(AID name) throws NotFoundException {
        AgentDescriptor ad = this.platformAgents.acquire(name);
        if (ad == null) {
            throw new NotFoundException("ResumedAgent failed to find " + name);
        }
        AMSAgentDescription amsd = ad.getDescription();
        if (amsd != null) {
            amsd.setState("active");
        }
        ContainerID cid = ad.getContainerID();
        this.platformAgents.release(name);
        this.fireResumedAgent(cid, name);
    }

    public void movedAgent(AID agentID, ContainerID srcID, ContainerID destID) throws NotFoundException {
        AgentDescriptor ad = this.platformAgents.acquire(agentID);
        if (ad == null) {
            throw new NotFoundException("Agent " + agentID.getName() + " not found in GADT");
        }
        ad.setContainerID(destID);
        this.fireMovedAgent(srcID, destID, agentID);
        this.platformAgents.release(agentID);
    }

    public void frozenAgent(AID name, ContainerID bufferContainer) throws NotFoundException {
        AgentDescriptor ad = this.platformAgents.acquire(name);
        if (ad == null) {
            throw new NotFoundException("FrozenAgent failed to find " + name);
        }
        AMSAgentDescription amsd = ad.getDescription();
        if (amsd != null) {
            amsd.setState("suspended");
        }
        ContainerID cid = ad.getContainerID();
        this.platformAgents.release(name);
        this.fireFrozenAgent(cid, name, bufferContainer);
    }

    public void thawedAgent(AID name, ContainerID bufferContainer) throws NotFoundException {
        AgentDescriptor ad = this.platformAgents.acquire(name);
        if (ad == null) {
            throw new NotFoundException("ThawedAgent failed to find " + name);
        }
        AMSAgentDescription amsd = ad.getDescription();
        if (amsd != null) {
            amsd.setState("active");
        }
        ContainerID cid = ad.getContainerID();
        this.platformAgents.release(name);
        this.fireThawedAgent(cid, name, bufferContainer);
    }

    public void newMTP(MTPDescriptor mtp, ContainerID cid) throws IMTPException {
        try {
            String[] mtpAddrs = mtp.getAddresses();
            String mtpAddress = mtpAddrs[0];
            this.platformAddresses.add(mtpAddress);
            this.containers.addMTP(cid, mtp);
            AID[] allIds = this.platformAgents.keys();
            int i = 0;
            while (i < allIds.length) {
                AgentDescriptor ad = this.platformAgents.acquire(allIds[i]);
                AMSAgentDescription dsc = ad.getDescription();
                if (dsc != null && ad.isNative()) {
                    AID id = dsc.getName();
                    id.addAddresses(mtpAddress);
                }
                this.platformAgents.release(allIds[i]);
                ++i;
            }
            this.fireAddedMTP(mtp, cid);
        }
        catch (NotFoundException nfe) {
            System.out.println("Error: the container " + cid.getName() + " was not found.");
        }
    }

    public void deadMTP(MTPDescriptor mtp, ContainerID cid) throws IMTPException {
        try {
            String[] mtpAddrs = mtp.getAddresses();
            String mtpAddress = mtpAddrs[0];
            this.platformAddresses.remove(mtpAddress);
            this.containers.removeMTP(cid, mtp);
            AID[] allIds = this.platformAgents.keys();
            int i = 0;
            while (i < allIds.length) {
                AgentDescriptor ad = this.platformAgents.acquire(allIds[i]);
                AMSAgentDescription dsc = ad.getDescription();
                if (ad.isNative()) {
                    AID id = dsc.getName();
                    id.removeAddresses(mtpAddress);
                }
                this.platformAgents.release(allIds[i]);
                ++i;
            }
            this.fireRemovedMTP(mtp, cid);
        }
        catch (NotFoundException nfe) {
            System.out.println("Error: the container " + cid.getName() + " was not found.");
        }
    }

    public void addTool(AID tool) {
        GenericCommand cmd = new GenericCommand("Add-Tool", "jade.core.management.AgentManagement", null);
        cmd.addParam(tool);
        Object ret = this.myCommandProcessor.processOutgoing(cmd);
        if (ret != null && ret instanceof Throwable) {
            ((Throwable)ret).printStackTrace();
        }
    }

    public void removeTool(AID tool) {
        GenericCommand cmd = new GenericCommand("Remove-Tool", "jade.core.management.AgentManagement", null);
        cmd.addParam(tool);
        Object ret = this.myCommandProcessor.processOutgoing(cmd);
        if (ret != null && ret instanceof Throwable) {
            ((Throwable)ret).printStackTrace();
        }
    }

    public void create(String name, String className, Object[] args, ContainerID cid, JADEPrincipal owner, Credentials initialCredentials, JADEPrincipal requesterPrincipal, Credentials requesterCredentials) throws UnreachableException, JADESecurityException, NotFoundException, NameClashException {
        if (cid == null || cid.getName() == null) {
            cid = this.localContainerID;
        }
        GenericCommand cmd = new GenericCommand("Request-Create", "jade.core.management.AgentManagement", null);
        cmd.addParam(name);
        cmd.addParam(className);
        cmd.addParam(args);
        cmd.addParam(cid);
        cmd.addParam(owner);
        cmd.addParam(initialCredentials);
        cmd.setPrincipal(requesterPrincipal);
        cmd.setCredentials(requesterCredentials);
        Object ret = this.myCommandProcessor.processOutgoing(cmd);
        if (ret != null) {
            if (ret instanceof NotFoundException) {
                throw (NotFoundException)ret;
            }
            if (ret instanceof NameClashException) {
                throw (NameClashException)ret;
            }
            if (ret instanceof IMTPException) {
                throw new UnreachableException("", (IMTPException)ret);
            }
            if (ret instanceof JADESecurityException) {
                throw (JADESecurityException)ret;
            }
            if (ret instanceof Throwable) {
                ((Throwable)ret).printStackTrace();
                throw new RuntimeException(((Throwable)ret).getMessage());
            }
        }
    }

    public void kill(AID agentID, JADEPrincipal requesterPrincipal, Credentials requesterCredentials) throws NotFoundException, UnreachableException, JADESecurityException {
        GenericCommand cmd = new GenericCommand("Request-Kill", "jade.core.management.AgentManagement", null);
        cmd.addParam(agentID);
        cmd.setPrincipal(requesterPrincipal);
        cmd.setCredentials(requesterCredentials);
        Object ret = this.myCommandProcessor.processOutgoing(cmd);
        if (ret != null) {
            if (ret instanceof NotFoundException) {
                throw (NotFoundException)ret;
            }
            if (ret instanceof IMTPException) {
                throw new UnreachableException("", (IMTPException)ret);
            }
            if (ret instanceof JADESecurityException) {
                throw (JADESecurityException)ret;
            }
            if (ret instanceof Throwable) {
                throw new RuntimeException(((Throwable)ret).getMessage());
            }
        }
    }

    public void suspend(AID agentID) throws NotFoundException, UnreachableException, JADESecurityException {
        GenericCommand cmd = new GenericCommand("Request-State-Change", "jade.core.management.AgentManagement", null);
        cmd.addParam(agentID);
        cmd.addParam(AgentState.getInstance(4));
        Object ret = this.myCommandProcessor.processOutgoing(cmd);
        if (ret != null) {
            if (ret instanceof NotFoundException) {
                throw (NotFoundException)ret;
            }
            if (ret instanceof IMTPException) {
                throw new UnreachableException("", (IMTPException)ret);
            }
            if (ret instanceof JADESecurityException) {
                throw (JADESecurityException)ret;
            }
            if (ret instanceof Throwable) {
                throw new RuntimeException(((Throwable)ret).getMessage());
            }
        }
    }

    public void activate(AID agentID) throws NotFoundException, UnreachableException, JADESecurityException {
        GenericCommand cmd = new GenericCommand("Request-State-Change", "jade.core.management.AgentManagement", null);
        cmd.addParam(agentID);
        cmd.addParam(AgentState.getInstance(2));
        Object ret = this.myCommandProcessor.processOutgoing(cmd);
        if (ret != null) {
            if (ret instanceof NotFoundException) {
                throw (NotFoundException)ret;
            }
            if (ret instanceof IMTPException) {
                throw new UnreachableException("", (IMTPException)ret);
            }
            if (ret instanceof JADESecurityException) {
                throw (JADESecurityException)ret;
            }
            if (ret instanceof Throwable) {
                throw new RuntimeException(((Throwable)ret).getMessage());
            }
        }
    }

    public void wait(AID agentID, String password) throws NotFoundException, UnreachableException {
        GenericCommand cmd = new GenericCommand("Request-State-Change", "jade.core.management.AgentManagement", null);
        cmd.addParam(agentID);
        cmd.addParam(AgentState.getInstance(5));
        Object ret = this.myCommandProcessor.processOutgoing(cmd);
        if (ret != null) {
            if (ret instanceof NotFoundException) {
                throw (NotFoundException)ret;
            }
            if (ret instanceof IMTPException) {
                throw new UnreachableException("", (IMTPException)ret);
            }
            if (ret instanceof Throwable) {
                throw new RuntimeException(((Throwable)ret).getMessage());
            }
        }
    }

    public void wake(AID agentID, String password) throws NotFoundException, UnreachableException {
        GenericCommand cmd = new GenericCommand("Request-State-Change", "jade.core.management.AgentManagement", null);
        cmd.addParam(agentID);
        cmd.addParam(AgentState.getInstance(2));
        Object ret = this.myCommandProcessor.processOutgoing(cmd);
        if (ret != null) {
            if (ret instanceof NotFoundException) {
                throw (NotFoundException)ret;
            }
            if (ret instanceof IMTPException) {
                throw new UnreachableException("", (IMTPException)ret);
            }
            if (ret instanceof Throwable) {
                throw new RuntimeException(((Throwable)ret).getMessage());
            }
        }
    }

    public void move(AID agentID, Location where) throws NotFoundException, UnreachableException, JADESecurityException {
        ContainerID to = (ContainerID)where;
        this.getDescriptor(to.getName());
        GenericCommand cmd = new GenericCommand("Request-Move", "jade.core.mobility.AgentMobility", null);
        cmd.addParam(agentID);
        cmd.addParam(where);
        Object ret = this.myCommandProcessor.processOutgoing(cmd);
        if (ret != null) {
            if (ret instanceof NotFoundException) {
                throw (NotFoundException)ret;
            }
            if (ret instanceof IMTPException) {
                throw new UnreachableException("", (IMTPException)ret);
            }
            if (ret instanceof JADESecurityException) {
                throw (JADESecurityException)ret;
            }
            if (ret instanceof Throwable) {
                throw new RuntimeException(((Throwable)ret).getMessage());
            }
        }
    }

    public void copy(AID agentID, Location where, String newName) throws NotFoundException, NameClashException, UnreachableException, JADESecurityException {
        ContainerID to = (ContainerID)where;
        this.getDescriptor(to.getName());
        GenericCommand cmd = new GenericCommand("Request-Clone", "jade.core.mobility.AgentMobility", null);
        cmd.addParam(agentID);
        cmd.addParam(where);
        cmd.addParam(newName);
        Object ret = this.myCommandProcessor.processOutgoing(cmd);
        if (ret != null) {
            if (ret instanceof NotFoundException) {
                throw (NotFoundException)ret;
            }
            if (ret instanceof NameClashException) {
                throw (NameClashException)ret;
            }
            if (ret instanceof IMTPException) {
                throw new UnreachableException("", (IMTPException)ret);
            }
            if (ret instanceof JADESecurityException) {
                throw (JADESecurityException)ret;
            }
            if (ret instanceof Throwable) {
                throw new RuntimeException(((Throwable)ret).getMessage());
            }
        }
    }

    public void killContainer(ContainerID cid, JADEPrincipal requesterPrincipal, Credentials requesterCredentials) throws NotFoundException, UnreachableException, JADESecurityException {
        GenericCommand cmd = new GenericCommand("Kill-Container", "jade.core.management.AgentManagement", null);
        cmd.addParam(cid);
        cmd.setPrincipal(requesterPrincipal);
        cmd.setCredentials(requesterCredentials);
        Object ret = this.myCommandProcessor.processOutgoing(cmd);
        if (ret != null) {
            if (ret instanceof NotFoundException) {
                throw (NotFoundException)ret;
            }
            if (ret instanceof JADESecurityException) {
                throw (JADESecurityException)ret;
            }
            if (ret instanceof IMTPException) {
                throw new UnreachableException("", (IMTPException)ret);
            }
            if (ret instanceof Throwable) {
                throw new RuntimeException(ret.toString());
            }
        }
    }

    public void shutdownPlatform(JADEPrincipal requesterPrincipal, Credentials requesterCredentials) throws JADESecurityException {
        block20: {
            if (this.myLogger.isLoggable(Logger.FINE)) {
                this.myLogger.log(Logger.FINE, "Shutting down agent platform.");
            }
            int cnt = 0;
            ContainerID[] allContainers = this.containers.names();
            int i = 0;
            while (i < allContainers.length) {
                ContainerID targetID = allContainers[i];
                NodeDescriptor dsc = this.myPlatformManager.getDescriptor(targetID.getName());
                if (dsc != null) {
                    if (dsc.getParentNode() != null) {
                        this.shutdownContainer(targetID, "Container", requesterPrincipal, requesterCredentials);
                        ++cnt;
                    }
                } else {
                    this.removeRemoteContainer(targetID);
                }
                ++i;
            }
            if (cnt > 0 && this.myLogger.isLoggable(Logger.FINER)) {
                this.myLogger.log(Logger.FINER, "Containers on child nodes shutdown completed.");
            }
            cnt = 0;
            allContainers = this.containers.names();
            int i2 = 0;
            while (i2 < allContainers.length) {
                ContainerID targetID = allContainers[i2];
                NodeDescriptor dsc = this.myPlatformManager.getDescriptor(targetID.getName());
                if (dsc != null) {
                    if (!dsc.getNode().hasPlatformManager()) {
                        this.shutdownContainer(targetID, "Container", requesterPrincipal, requesterCredentials);
                        ++cnt;
                    }
                } else {
                    this.removeRemoteContainer(targetID);
                }
                ++i2;
            }
            if (cnt > 0 && this.myLogger.isLoggable(Logger.FINER)) {
                this.myLogger.log(Logger.FINER, "Peripheral containers shutdown completed.");
            }
            this.myPlatformManager.shutdown();
            cnt = 0;
            allContainers = this.containers.names();
            int i3 = 0;
            while (i3 < allContainers.length) {
                ContainerID targetID = allContainers[i3];
                if (!targetID.equals(this.localContainerID)) {
                    this.shutdownContainer(targetID, "Main Container", requesterPrincipal, requesterCredentials);
                    ++cnt;
                }
                ++i3;
            }
            if (cnt > 0 && this.myLogger.isLoggable(Logger.FINER)) {
                this.myLogger.log(Logger.FINER, "Backup Main Containers shutdown completed.");
            }
            try {
                if (this.myLogger.isLoggable(Logger.FINEST)) {
                    this.myLogger.log(Logger.FINEST, "Killing local node " + this.localContainerID.getName());
                }
                this.killContainer(this.localContainerID, requesterPrincipal, requesterCredentials);
                boolean removed = this.containers.waitUntilEmpty(5000L);
                if (!removed || !this.myLogger.isLoggable(Logger.FINEST)) break block20;
                this.myLogger.log(Logger.FINEST, "Local node shutdown completed.");
            }
            catch (NotFoundException nfe) {
                this.myLogger.log(Logger.FINE, "Container " + this.localContainerID.getName() + " does not exist. Ignoring...");
            }
            catch (UnreachableException ue) {
                this.myLogger.log(Logger.WARNING, "Cannot kill container " + this.localContainerID.getName() + ": Unreachable. " + ue);
            }
            catch (JADESecurityException se) {
                throw se;
            }
            catch (Throwable t) {
                this.myLogger.log(Logger.WARNING, "Cannot kill container " + this.localContainerID.getName() + ": Unexpected error. " + t);
            }
        }
    }

    private void shutdownContainer(ContainerID targetID, String type, JADEPrincipal requesterPrincipal, Credentials requesterCredentials) throws JADESecurityException {
        try {
            if (this.myLogger.isLoggable(Logger.FINEST)) {
                this.myLogger.log(Logger.FINEST, "Killing " + type + " " + targetID.getName());
            }
            this.killContainer(targetID, requesterPrincipal, requesterCredentials);
            boolean removed = this.containers.waitForRemoval(targetID, 5000L);
            if (removed) {
                if (this.myLogger.isLoggable(Logger.FINEST)) {
                    this.myLogger.log(Logger.FINEST, type + " " + targetID.getName() + " shutdown completed");
                }
                return;
            }
        }
        catch (NotFoundException nfe) {
            this.myLogger.log(Logger.FINE, "Container " + targetID.getName() + " does not exist. Ignoring...");
        }
        catch (UnreachableException ue) {
            this.myLogger.log(Logger.WARNING, "Cannot kill container " + targetID.getName() + ": Unreachable.");
        }
        catch (JADESecurityException se) {
            throw se;
        }
        catch (Throwable t) {
            this.myLogger.log(Logger.WARNING, "Cannot kill container " + targetID.getName() + ": Unexpected error. " + t);
        }
        this.removeRemoteContainer(targetID);
    }

    public MTPDescriptor installMTP(String address, ContainerID cid, String className) throws NotFoundException, UnreachableException, MTPException {
        GenericCommand cmd = new GenericCommand("Install-MTP", "jade.core.messaging.Messaging", null);
        cmd.addParam(address);
        cmd.addParam(cid);
        cmd.addParam(className);
        Object ret = this.myCommandProcessor.processOutgoing(cmd);
        if (ret != null) {
            if (ret instanceof NotFoundException) {
                throw (NotFoundException)ret;
            }
            if (ret instanceof IMTPException) {
                throw new UnreachableException("", (IMTPException)ret);
            }
            if (ret instanceof MTPException) {
                throw (MTPException)ret;
            }
            if (ret instanceof Throwable) {
                throw new RuntimeException(((Throwable)ret).getMessage());
            }
        }
        MTPDescriptor dsc = (MTPDescriptor)ret;
        return dsc;
    }

    public void uninstallMTP(String address, ContainerID cid) throws NotFoundException, UnreachableException, MTPException {
        GenericCommand cmd = new GenericCommand("Uninstall-MTP", "jade.core.messaging.Messaging", null);
        cmd.addParam(address);
        cmd.addParam(cid);
        Object ret = this.myCommandProcessor.processOutgoing(cmd);
        if (ret != null) {
            if (ret instanceof NotFoundException) {
                throw (NotFoundException)ret;
            }
            if (ret instanceof IMTPException) {
                throw new UnreachableException("", (IMTPException)ret);
            }
            if (ret instanceof MTPException) {
                throw (MTPException)ret;
            }
            if (ret instanceof Throwable) {
                throw new RuntimeException(((Throwable)ret).getMessage());
            }
        }
    }

    public void take(AID agentID, String username, byte[] password) throws NotFoundException, UnreachableException, JADESecurityException {
    }

    public void sniffOn(AID snifferName, List toBeSniffed) throws NotFoundException, UnreachableException {
        GenericCommand cmd = new GenericCommand("Sniff-On", "jade.core.event.Notification", null);
        cmd.addParam(snifferName);
        cmd.addParam(toBeSniffed);
        Object ret = this.myCommandProcessor.processOutgoing(cmd);
        if (ret != null) {
            if (ret instanceof NotFoundException) {
                throw (NotFoundException)ret;
            }
            if (ret instanceof IMTPException) {
                throw new UnreachableException("", (IMTPException)ret);
            }
            if (ret instanceof Throwable) {
                throw new RuntimeException(((Throwable)ret).getMessage());
            }
        }
    }

    public void sniffOff(AID snifferName, List notToBeSniffed) throws NotFoundException, UnreachableException {
        GenericCommand cmd = new GenericCommand("Sniff-Off", "jade.core.event.Notification", null);
        cmd.addParam(snifferName);
        cmd.addParam(notToBeSniffed);
        Object ret = this.myCommandProcessor.processOutgoing(cmd);
        if (ret != null) {
            if (ret instanceof NotFoundException) {
                throw (NotFoundException)ret;
            }
            if (ret instanceof IMTPException) {
                throw new UnreachableException("", (IMTPException)ret);
            }
            if (ret instanceof Throwable) {
                throw new RuntimeException(((Throwable)ret).getMessage());
            }
        }
    }

    public void debugOn(AID debuggerName, List toBeDebugged) throws NotFoundException, UnreachableException {
        GenericCommand cmd = new GenericCommand("Debug-On", "jade.core.event.Notification", null);
        cmd.addParam(debuggerName);
        cmd.addParam(toBeDebugged);
        Object ret = this.myCommandProcessor.processOutgoing(cmd);
        if (ret != null) {
            if (ret instanceof NotFoundException) {
                throw (NotFoundException)ret;
            }
            if (ret instanceof IMTPException) {
                throw new UnreachableException("", (IMTPException)ret);
            }
            if (ret instanceof Throwable) {
                throw new RuntimeException(((Throwable)ret).getMessage());
            }
        }
    }

    public void debugOff(AID debuggerName, List notToBeDebugged) throws NotFoundException, UnreachableException {
        GenericCommand cmd = new GenericCommand("Debug-Off", "jade.core.event.Notification", null);
        cmd.addParam(debuggerName);
        cmd.addParam(notToBeDebugged);
        Object ret = this.myCommandProcessor.processOutgoing(cmd);
        if (ret != null) {
            if (ret instanceof NotFoundException) {
                throw (NotFoundException)ret;
            }
            if (ret instanceof IMTPException) {
                throw new UnreachableException("", (IMTPException)ret);
            }
            if (ret instanceof Throwable) {
                throw new RuntimeException(((Throwable)ret).getMessage());
            }
        }
    }

    public void amsRegister(AMSAgentDescription dsc) throws AlreadyRegistered, JADESecurityException {
        AID agentID = dsc.getName();
        AgentDescriptor ad = this.platformAgents.acquire(agentID);
        if (ad == null) {
            System.out.println("No descriptor found for agent " + agentID);
            ad = new AgentDescriptor(true);
            ad.setDescription(dsc);
            this.platformAgents.put(agentID, ad);
        } else if (ad.getDescription() == null) {
            System.out.println("Descriptor with null AMSD found for agent " + agentID);
            ad.setDescription(dsc);
            this.platformAgents.release(agentID);
        } else {
            System.out.println("Descriptor with NON null AMSD found for agent " + agentID);
            this.platformAgents.release(agentID);
            throw new AlreadyRegistered();
        }
    }

    public void amsDeregister(AMSAgentDescription dsc) throws NotRegistered, JADESecurityException {
        AID agentID = dsc.getName();
        AgentDescriptor ad = this.platformAgents.acquire(agentID);
        if (ad != null && ad.getDescription() != null) {
            if (ad.isNative()) {
                ad.setDescription(null);
                this.platformAgents.release(agentID);
            } else {
                this.platformAgents.remove(agentID);
            }
            return;
        }
        throw new NotRegistered();
    }

    public void amsModify(AMSAgentDescription dsc) throws NotRegistered, NotFoundException, UnreachableException, JADESecurityException {
        AMSAgentDescription oldDsc;
        AID agentID = dsc.getName();
        AgentDescriptor ad = this.platformAgents.acquire(agentID);
        if (ad != null && (oldDsc = ad.getDescription()) != null) {
            ad.setDescription(dsc);
            String newState = dsc.getState();
            String newOwnership = dsc.getOwnership();
            if (newOwnership == null) {
                newOwnership = oldDsc.getOwnership();
            }
            this.platformAgents.release(agentID);
            if (ad.isNative()) {
                if ("suspended".equals(newState) && !"suspended".equals(oldDsc.getState())) {
                    this.suspend(agentID);
                }
                if ("active".equals(newState) && !"active".equals(oldDsc.getState())) {
                    this.activate(agentID);
                }
                if (newOwnership == null || newOwnership != oldDsc.getOwnership()) {
                    // empty if block
                }
            }
            return;
        }
        throw new NotRegistered();
    }

    public List amsSearch(AMSAgentDescription template, long maxResults) {
        ArrayList results = new ArrayList();
        AID[] ids = this.platformAgents.keys();
        int i = 0;
        while (i < ids.length) {
            try {
                AMSAgentDescription amsd = this.getAMSDescription(ids[i]);
                if (this.match(template, amsd)) {
                    results.add(amsd);
                    if ((long)results.size() >= maxResults) {
                        break;
                    }
                }
            }
            catch (NotFoundException nfe) {
                // empty catch block
            }
            ++i;
        }
        return results;
    }

    public ContainerID[] containerIDs() {
        return this.containers.names();
    }

    public AID[] agentNames() {
        return this.platformAgents.keys();
    }

    public List containerMTPs(ContainerID cid) throws NotFoundException {
        return this.containers.getMTPs(cid);
    }

    public List containerAgents(ContainerID cid) throws NotFoundException {
        ArrayList agents = new ArrayList();
        AID[] allIds = this.platformAgents.keys();
        int i = 0;
        while (i < allIds.length) {
            AID id = allIds[i];
            AgentDescriptor ad = this.platformAgents.acquire(id);
            ContainerID cid1 = ad.getContainerID();
            if (cid.equals(cid1)) {
                agents.add(id);
            }
            this.platformAgents.release(id);
            ++i;
        }
        return agents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toolAdded(AID tool) {
        List list = this.agentTools;
        synchronized (list) {
            if (!this.agentTools.contains(tool)) {
                this.agentTools.add(tool);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toolRemoved(AID tool) {
        List list = this.agentTools;
        synchronized (list) {
            this.agentTools.remove(tool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AID[] agentTools() {
        List list = this.agentTools;
        synchronized (list) {
            Object[] objs = this.agentTools.toArray();
            AID[] result = new AID[objs.length];
            int i = 0;
            while (i < result.length) {
                result[i] = (AID)objs[i];
                ++i;
            }
            return result;
        }
    }

    public ContainerID getContainerID(AID agentID) throws NotFoundException {
        AgentDescriptor ad = this.platformAgents.acquire(agentID);
        if (ad == null) {
            throw new NotFoundException("getContainerID() failed to find agent " + agentID.getName());
        }
        ContainerID result = ad.getContainerID();
        this.platformAgents.release(agentID);
        return result;
    }

    public NodeDescriptor getContainerNode(ContainerID cid) throws NotFoundException {
        return this.getDescriptor(cid.getName());
    }

    public AMSAgentDescription getAMSDescription(AID agentID) throws NotFoundException {
        AgentDescriptor ad = this.platformAgents.acquire(agentID);
        if (ad == null) {
            throw new NotFoundException("getAMSDescription() failed to find agent " + agentID.getName());
        }
        AMSAgentDescription amsd = ad.getDescription();
        this.platformAgents.release(agentID);
        return amsd;
    }

    public void addListener(AgentManager.Listener l) {
        this.platformListeners.add(l);
    }

    public void removeListener(AgentManager.Listener l) {
        this.platformListeners.remove(l);
    }

    private NodeDescriptor getDescriptor(String name) throws NotFoundException {
        NodeDescriptor dsc = this.myPlatformManager.getDescriptor(name);
        if (dsc == null) {
            throw new NotFoundException("Node  " + name + " not found.");
        }
        return dsc;
    }

    private boolean match(AMSAgentDescription templateDesc, AMSAgentDescription factDesc) {
        try {
            AID id2;
            String s2;
            String o2;
            String o1 = templateDesc.getOwnership();
            if (!(o1 == null || (o2 = factDesc.getOwnership()) != null && o1.equalsIgnoreCase(o2))) {
                return false;
            }
            String s1 = templateDesc.getState();
            if (!(s1 == null || (s2 = factDesc.getState()) != null && s1.equalsIgnoreCase(s2))) {
                return false;
            }
            AID id1 = templateDesc.getName();
            return id1 == null || (id2 = factDesc.getName()) != null && this.matchAID(id1, id2);
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    private final boolean matchAID(AID template, AID fact) {
        boolean found;
        String factName;
        String templateName = template.getName();
        if (!(templateName == null || (factName = fact.getName()) != null && templateName.equalsIgnoreCase(factName))) {
            return false;
        }
        Iterator itTemplate = template.getAllAddresses();
        Iterator itFact = fact.getAllAddresses();
        while (itTemplate.hasNext()) {
            String templateAddr = (String)itTemplate.next();
            found = false;
            while (!found && itFact.hasNext()) {
                String factAddr = (String)itFact.next();
                found = templateAddr.equalsIgnoreCase(factAddr);
            }
            if (found) continue;
            return false;
        }
        itTemplate = template.getAllResolvers();
        itFact = fact.getAllResolvers();
        while (itTemplate.hasNext()) {
            AID templateRes = (AID)itTemplate.next();
            found = false;
            while (!found && itFact.hasNext()) {
                AID factRes = (AID)itFact.next();
                found = this.matchAID(templateRes, factRes);
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private void fireAddedContainer(ContainerID cid) {
        PlatformEvent ev = new PlatformEvent(1, cid);
        int i = 0;
        while (i < this.platformListeners.size()) {
            AgentManager.Listener l = (AgentManager.Listener)this.platformListeners.get(i);
            l.addedContainer(ev);
            ++i;
        }
    }

    private void fireRemovedContainer(ContainerID cid) {
        PlatformEvent ev = new PlatformEvent(2, cid);
        int i = 0;
        while (i < this.platformListeners.size()) {
            AgentManager.Listener l = (AgentManager.Listener)this.platformListeners.get(i);
            l.removedContainer(ev);
            ++i;
        }
    }

    private void fireBornAgent(ContainerID cid, AID agentID, String ownership) {
        PlatformEvent ev = new PlatformEvent(3, agentID, cid, null, ownership);
        int i = 0;
        while (i < this.platformListeners.size()) {
            AgentManager.Listener l = (AgentManager.Listener)this.platformListeners.get(i);
            l.bornAgent(ev);
            ++i;
        }
    }

    private void fireDeadAgent(ContainerID cid, AID agentID, boolean containerRemoved) {
        PlatformEvent ev = new PlatformEvent(4, agentID, cid, containerRemoved);
        int i = 0;
        while (i < this.platformListeners.size()) {
            AgentManager.Listener l = (AgentManager.Listener)this.platformListeners.get(i);
            l.deadAgent(ev);
            ++i;
        }
    }

    private void fireSuspendedAgent(ContainerID cid, AID agentID) {
        PlatformEvent ev = new PlatformEvent(6, agentID, cid);
        int i = 0;
        while (i < this.platformListeners.size()) {
            AgentManager.Listener l = (AgentManager.Listener)this.platformListeners.get(i);
            l.suspendedAgent(ev);
            ++i;
        }
    }

    private void fireResumedAgent(ContainerID cid, AID agentID) {
        PlatformEvent ev = new PlatformEvent(7, agentID, cid);
        int i = 0;
        while (i < this.platformListeners.size()) {
            AgentManager.Listener l = (AgentManager.Listener)this.platformListeners.get(i);
            l.resumedAgent(ev);
            ++i;
        }
    }

    private void fireFrozenAgent(ContainerID cid, AID agentID, ContainerID bufferContainer) {
        PlatformEvent ev = new PlatformEvent(10, agentID, cid, bufferContainer);
        int i = 0;
        while (i < this.platformListeners.size()) {
            AgentManager.Listener l = (AgentManager.Listener)this.platformListeners.get(i);
            l.frozenAgent(ev);
            ++i;
        }
    }

    private void fireThawedAgent(ContainerID cid, AID agentID, ContainerID bufferContainer) {
        PlatformEvent ev = new PlatformEvent(11, agentID, cid, bufferContainer);
        int i = 0;
        while (i < this.platformListeners.size()) {
            AgentManager.Listener l = (AgentManager.Listener)this.platformListeners.get(i);
            l.thawedAgent(ev);
            ++i;
        }
    }

    private void fireMovedAgent(ContainerID from, ContainerID to, AID agentID) {
        PlatformEvent ev = new PlatformEvent(agentID, from, to);
        int i = 0;
        while (i < this.platformListeners.size()) {
            AgentManager.Listener l = (AgentManager.Listener)this.platformListeners.get(i);
            l.movedAgent(ev);
            ++i;
        }
    }

    private void fireAddedMTP(MTPDescriptor mtp, ContainerID cid) {
        String name = mtp.getName();
        String[] addrs = mtp.getAddresses();
        Channel ch = new Channel("FIXME: missing channel name", name, addrs[0]);
        MTPEvent ev = new MTPEvent(1, cid, ch);
        int i = 0;
        while (i < this.platformListeners.size()) {
            AgentManager.Listener l = (AgentManager.Listener)this.platformListeners.get(i);
            l.addedMTP(ev);
            ++i;
        }
    }

    private void fireRemovedMTP(MTPDescriptor mtp, ContainerID cid) {
        String name = mtp.getName();
        String[] addrs = mtp.getAddresses();
        Channel ch = new Channel("FIXME: missing channel name", name, addrs[0]);
        MTPEvent ev = new MTPEvent(2, cid, ch);
        int i = 0;
        while (i < this.platformListeners.size()) {
            AgentManager.Listener l = (AgentManager.Listener)this.platformListeners.get(i);
            l.removedMTP(ev);
            ++i;
        }
    }

    private void removeAllAgents(ContainerID cid) {
        String name = cid.getName();
        AID[] allIDs = this.platformAgents.keys();
        int i = 0;
        while (i < allIDs.length) {
            AgentDescriptor ad = this.platformAgents.acquire(allIDs[i]);
            ContainerID id = ad.getContainerID();
            if (CaseInsensitiveString.equalsIgnoreCase(id.getName(), name)) {
                if (!allIDs[i].getLocalName().equalsIgnoreCase("ams")) {
                    this.platformAgents.release(allIDs[i]);
                    try {
                        this.deadAgent(allIDs[i], true);
                    }
                    catch (NotFoundException nfe) {
                        nfe.printStackTrace();
                    }
                } else {
                    ad.getDescription().setState("latent");
                    this.platformAgents.release(allIDs[i]);
                }
            } else {
                this.platformAgents.release(allIDs[i]);
            }
            ++i;
        }
    }

    private void removeAllMTPs(ContainerID cid) {
        try {
            List l = this.containers.getMTPs(cid);
            Object[] objs = l.toArray();
            int i = 0;
            while (i < objs.length) {
                MTPDescriptor mtp = (MTPDescriptor)objs[i];
                GenericCommand gCmd = new GenericCommand("Dead-MTP", "jade.core.messaging.Messaging", null);
                gCmd.addParam(mtp);
                gCmd.addParam(cid);
                this.myCommandProcessor.processOutgoing(gCmd);
                ++i;
            }
        }
        catch (NotFoundException nfe) {
            nfe.printStackTrace();
        }
    }

    public AgentDescriptor acquireAgentDescriptor(AID agentID) {
        return this.platformAgents.acquire(agentID);
    }

    public void releaseAgentDescriptor(AID agentID) {
        this.platformAgents.release(agentID);
    }
}

